#define MyAppName "   "
#define MyCompany " "
#define MyAppVerName "1.5.3.12"
#define MainExeName "KDU-3.exe"
#define HelpFileName "KDU-3.chm"

[Languages]
Name: "russian"; MessagesFile: "KDU_Russian.isl"

[Setup]
AppName={#MyAppName}
AppVerName={#MyAppVerName}
VersionInfoVersion={#MyAppVerName}
UninstallDisplayName={#MyAppName} v.{#MyAppVerName}
AppMutex=ComsignalKDU_1
VersionInfoDescription=    
DefaultDirName={pf}\Comsignal Ltd\KDU
DefaultGroupName= 
AlwaysShowGroupOnReadyPage=false
AppID=KDU_1.5
UsePreviousAppDir=true
Compression=lzma2/Max
InternalCompressLevel=Max
SolidCompression=true
OutputDir=.
OutputBaseFilename=KDUSetup_{#MyAppVerName}
ChangesAssociations=true
AlwaysShowDirOnReadyPage=true
AllowNoIcons=false
AppPublisher={#MyCompany}
AppPublisherURL=http://comsignal.ru/
AppVersion=1.5
AppContact=support@comsignal.ru
AppSupportURL=http://comsignal.ru/support.html
AppUpdatesURL=http://kdu.comsignal.ru/
VersionInfoCompany={#MyCompany}
AppCopyright={#MyCompany} , 2002-2022
ShowLanguageDialog=no
WizardImageFile=left.bmp
WizardSmallImageFile=small.bmp
VersionInfoCopyright= 2022,  ""
VersionInfoProductName= 

[InstallDelete]
;  cml   
Type: files; Name: "{app}\KDU-1.cml"
Type: files; Name: "{app}\KDU-1m.cml"
Type: files; Name: "{app}\KDU-3.1 (M).cml"
Type: files; Name: "{app}\KDU-3.2 (M).cml"
Type: files; Name: "{app}\KDU-3.2N.cml"
Type: files; Name: "{app}\KDU-3.3 (M).cml"
Type: files; Name: "{app}\KDU_3_3n.cml"
Type: files; Name: "{app}\KDU_3s.cml"

[Files]
;Source: "CDMUninstaller.exe"; DestDir: "{tmp}"; Components: driver\uninstall; BeforeInstall: RunProcessFromTmpFile('CDMUninstaller.exe', '0403 6001')
;Source: "CDM20814_Setup.exe"; DestDir: "{tmp}"; Components: driver; BeforeInstall: RunProcessFromTmpFile('CDM20814_Setup.exe', '')
Source: "{#MainExeName}"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: main
Source: "{#HelpFileName}"; DestDir: "{app}"; flags: replacesameversion; Components: help
Source: "KDU-3.ini"; DestDir: "{userappdata}\Comsignal Ltd\KDU"; flags: onlyifdoesntexist; Components: main
Source: "DataExp.dll"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: main
Source: "bass.dll"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: main
Source: "bzip2.dll"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: main
Source: "htmlhelp\*"; DestDir: "{app}\HtmlHelp.template"; flags: ignoreversion; Components: main
Source: "htmlhelp\Files\*"; DestDir: "{app}\HtmlHelp.template\Files"; flags: ignoreversion; Components: main
Source: "Templates\*"; DestDir: "{app}\ "; Components: templates
Source: "Templates\razm\*"; DestDir: "{app}\ \ "; Components: templates
Source: "cml\KDA_1.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; 
Source: "cml\KDA_2.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; 
Source: "cml\KDM_1.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdm1
Source: "cml\PSA_1.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\psa1
;Source: "cml\KDU_3.2NP.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu32np
Source: "cml\KDU_3.4N.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu34n
Source: "cml\KDU_3.6N.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu36n
Source: "cml\KDU_3.2N1.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu32n1
Source: "cml\KDU_3.3S.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu33s
Source: "cml\KDU_3.3N.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu33n
Source: "cml\KDU_3.2N.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu32n
Source: "cml\KDU_3.3M.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu33m
Source: "cml\KDU_3.2M.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu32m
Source: "cml\KDU_3.1M.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu31m
Source: "cml\KDU_3.3.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu33
Source: "cml\KDU_3.2.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu32
Source: "cml\KDU_3.1.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu31
Source: "cml\KDU_1.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu1
Source: "cml\KDU_1m.cml"; DestDir: "{app}"; flags: replacesameversion promptifolder; Components: libs\kdu1m

;Source: "Drivers\*"; DestDir: "{app}\Drivers"; flags: ignoreversion; 

[Components]
Name: "main"; Description: "  "; Types: full compact custom; Flags: fixed
Name: "templates"; Description: " "; Types: full compact custom; Flags: disablenouninstallwarning
Name: "help"; Description: " "; Types: full custom; Flags: disablenouninstallwarning

;Name: "driver"; Description: "  "; Types: custom; Flags: disablenouninstallwarning
;Name: "driver\uninstall"; Description: "  "; Types: custom; Flags: exclusive disablenouninstallwarning

Name: "libs"; Description: "  "; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdm1"; Description: "-1"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\psa1"; Description: "-1"; Types: full compact custom; Flags: disablenouninstallwarning
;Name: "libs\kdu32np"; Description: "-3.2"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu33s"; Description: "-3.3"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu36n"; Description: "-3.6"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu34n"; Description: "-3.4"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu33n"; Description: "-3.3"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu32n"; Description: "-3.2"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu33m"; Description: "-3.3"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu32m"; Description: "-3.2"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu31m"; Description: "-3.1"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu33"; Description: "-3.3"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu32"; Description: "-3.2"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu32n1"; Description: "-3.2."; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu31"; Description: "-3.1"; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu1"; Description: "-1 ."; Types: full compact custom; Flags: disablenouninstallwarning
Name: "libs\kdu1m"; Description: "-1 ."; Types: full compact custom; Flags: disablenouninstallwarning

[Run]
Filename: "{app}\{#MainExeName}"; Description: " "; Flags: postinstall nowait skipifsilent
Filename: "{app}\{#HelpFileName}"; Description: "  "; Flags: postinstall nowait shellexec skipifsilent unchecked; Components: help

[Icons]
Name: "{userdesktop}\"; Filename: "{app}\{#MainExeName}"; WorkingDir: "{app}"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\ "; Filename: "{app}\{#MainExeName}"; WorkingDir: "{app}"; Tasks: quicklaunchicon
Name: "{group}\ "; Filename: "{uninstallexe}"
Name: "{group}\"; Filename: "{app}\{#HelpFileName}"
Name: "{group}\ "; Filename: "{app}\{#MainExeName}"; WorkingDir: "{app}"

;[INI]
;Filename: "{userappdata}\Comsignal Ltd\KDU\KDU-3.ini"; Section: "General"; Key: "CheckAssociation"; String: "0"
;Filename: "{userappdata}\Comsignal Ltd\KDU\KDU-3.ini"; Section: "General"; Key: "CheckAssociation"; String: "1"; Tasks: associate_kdu

[Tasks]
Name: desktopicon; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}";
Name: quicklaunchicon; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: associations; Description: "   :"; GroupDescription: "{cm:AssocingFileExtension}";
Name: associations\associate_kdu; Description: "{cm:AssocFileExtension, .kdu}"; GroupDescription: "{cm:AssocingFileExtension}";
Name: associations\associate_uzs; Description: "{cm:AssocFileExtension, .uzs}"; GroupDescription: "{cm:AssocingFileExtension}";
Name: associations\associate_mso; Description: "{cm:AssocFileExtension, .mso}"; GroupDescription: "{cm:AssocingFileExtension}";
Name: associations\associate_kno; Description: "{cm:AssocFileExtension, .kno}"; GroupDescription: "{cm:AssocingFileExtension}";
Name: associations\associate_kmd; Description: "{cm:AssocFileExtension, .kmd}"; GroupDescription: "{cm:AssocingFileExtension}";

[Registry]
; .kdu
Root: HKCR; Subkey: ".kdu"; ValueType: string; ValueName: ""; ValueData: "KDU.Project"; Flags: uninsdeletekey; Tasks: associations\associate_kdu
Root: HKCR; Subkey: "KDU.Project"; ValueType: string; ValueName: ""; ValueData: "{#MyAppName}"; Tasks: associations\associate_kdu
Root: HKCR; Subkey: "KDU.Project\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MainExeName},0"; Flags: uninsdeletekey; Tasks: associations\associate_kdu
Root: HKCR; Subkey: "KDU.Project\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MainExeName}"" ""%1"""; Flags: uninsdeletekey; Tasks: associations\associate_kdu
; .uzs
Root: HKCR; Subkey: ".uzs"; ValueType: string; ValueName: ""; ValueData: "KDU.Project"; Flags: uninsdeletekey; Tasks: associations\associate_uzs
Root: HKCR; Subkey: "KDU.Project"; ValueType: string; ValueName: ""; ValueData: "{#MyAppName}"; Tasks: associations\associate_uzs
Root: HKCR; Subkey: "KDU.Project\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MainExeName},0"; Flags: uninsdeletekey; Tasks: associations\associate_uzs
Root: HKCR; Subkey: "KDU.Project\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MainExeName}"" ""%1"""; Flags: uninsdeletekey; Tasks: associations\associate_uzs
; .mso
Root: HKCR; Subkey: ".mso"; ValueType: string; ValueName: ""; ValueData: "KDU.Project"; Flags: uninsdeletekey; Tasks: associations\associate_mso
Root: HKCR; Subkey: "KDU.Project"; ValueType: string; ValueName: ""; ValueData: "{#MyAppName}"; Tasks: associations\associate_mso
Root: HKCR; Subkey: "KDU.Project\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MainExeName},0"; Flags: uninsdeletekey; Tasks: associations\associate_mso
Root: HKCR; Subkey: "KDU.Project\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MainExeName}"" ""%1"""; Flags: uninsdeletekey; Tasks: associations\associate_mso
; .kno
Root: HKCR; Subkey: ".kno"; ValueType: string; ValueName: ""; ValueData: "KDU.Project"; Flags: uninsdeletekey; Tasks: associations\associate_kno
Root: HKCR; Subkey: "KDU.Project"; ValueType: string; ValueName: ""; ValueData: "{#MyAppName}"; Tasks: associations\associate_kno
Root: HKCR; Subkey: "KDU.Project\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MainExeName},0"; Flags: uninsdeletekey; Tasks: associations\associate_kno
Root: HKCR; Subkey: "KDU.Project\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MainExeName}"" ""%1"""; Flags: uninsdeletekey; Tasks: associations\associate_kno
; .kmd
Root: HKCR; Subkey: ".kmd"; ValueType: string; ValueName: ""; ValueData: "KDU.Project"; Flags: uninsdeletekey; Tasks: associations\associate_kmd
Root: HKCR; Subkey: "KDU.Project"; ValueType: string; ValueName: ""; ValueData: "{#MyAppName}"; Tasks: associations\associate_kmd
Root: HKCR; Subkey: "KDU.Project\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MainExeName},0"; Flags: uninsdeletekey; Tasks: associations\associate_kmd
Root: HKCR; Subkey: "KDU.Project\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MainExeName}"" ""%1"""; Flags: uninsdeletekey; Tasks: associations\associate_kmd

;[InstallDelete]
;Type: files; Name: "{tmp}\CDM20814_Setup.exe"
;Type: files; Name: "{tmp}\CDMUninstaller.exe"

;[Code]
;procedure RunProcessFromTmpFile(S: string; Params: string);
;var
;  ResultCode: Integer;
;begin
;  ExtractTemporaryFile(S);
;  Exec(ExpandConstant('{tmp}\') + S, Params, '', SW_SHOWNORMAL, ewWaitUntilTerminated, ResultCode);
;  BringToFrontAndRestore();
;end;



























